var chart_replacement="<div class='chart_holder'><canvas id='one' class='chart' width='600' height='600'></canvas><canvas id='two' class='chart' width='600' height='600'></canvas><canvas id='three' class='chart' width='600' height='600'></canvas></div>";
	
var color_one="rgba(243,134,48,1.0)";
var color_two="rgba(192,162,41,1.0)";
var color_three="rgba(105,210,231,1.0)";

var faded_color_one="rgba(243,134,48,0.5)";
var faded_color_two="rgba(192,162,41,0.5)";
var faded_color_three="rgba(105,210,231,0.5)";

var darken_color_one="#AE510A";
var darken_color_two="#766319";
var darken_color_three="#22B5D3";

var lighten_color_three="#22B5D3";

var transparent_color='rgba(0,0,0,0)';
var grey_color='rgba(0,0,0,0.05)';

var data_empty = [
	{
		value: 30,
		color:faded_color_one
	},
	{
		value : 50,
		color:faded_color_two
	},
	{
		value : 100,
		color : faded_color_three
	}			
]

var data_grey = [
	{
		value: 30,
		color:grey_color
	},
	{
		value : 50,
		color:grey_color
	},
	{
		value : 100,
		color : grey_color
	}			
]

var data_one = [
	{
		value: 30,
		color:color_one,
		label : 'Option A'

	},
	{
		value : 50,
		color:transparent_color,
		label : 'Option B'

	},
	{
		value : 100,
		color : transparent_color,
		label : 'Option C'

	}			
]


var data_two = [
	{
		value: 30,
		color:transparent_color,
		label : 'Option A'

	},
	{
		value : 50,
		color:color_two,
		label : 'Option B'

	},
	{
		value : 100,
		color : transparent_color,
		label : 'Option C'

	}			
]

var data_three = [
	{
		value: 30,
		color:transparent_color,
		label : 'Option A'

	},
	{
		value : 50,
		color:transparent_color,
		label : 'Option B'

	},
	{
		value : 100,
		color : color_three,
		label : 'Option C'
	}			
]

var data_three_shadow = [
	{
		value: 30,
		color:transparent_color
	},
	{
		value : 50,
		color:transparent_color
	},
	{
		value : 100,
		color : color_three,
		shadow : false,
		shadow_color : lighten_color_three
	}			
]

var data_three_options = {
animation : false,
segmentShowStroke : true
};

		var chunk_fade_speed=100;
		var chunk_move_speed=100;
		
		function make_pie(options){
	    var ctx = document.getElementById("empty").getContext("2d");
	    var myNewChart_empty = new Chart(ctx).Pie(data_empty,options);

	    var ctx = document.getElementById("grey").getContext("2d");
	    var myNewChart_empty = new Chart(ctx).Pie(data_grey,options);
	    
	    var ctx = document.getElementById("one").getContext("2d");
	    var myNewChart_one = new Chart(ctx).Pie(data_one,options);
	    
	    var ctx = document.getElementById("two").getContext("2d");
	    var myNewChart_two = new Chart(ctx).Pie(data_two,options);	    
	    	    
	    var ctx = document.getElementById("three").getContext("2d");
	    var myNewChart_three = new Chart(ctx).Pie(data_three,options);
	    }
	    make_pie(0);

	    function chart_see(e){
	   		can_width=600;
	       	can_height=600;
	       	center_x=can_width/2;
	       	center_y=can_height/2;
	       	temp_length=center_x;
	
	       	var offset = $('.chart_holder').offset();
	       	
	       	x_raw=e.clientX - offset.left;
	       	x_coord=x_raw-center_x;
	       	
	       	y_raw=e.clientY - offset.top;
	       	y_coord=center_y-y_raw;
	
	       	x_delta=center_x-x_raw;
	       	y_delta=center_y-y_raw;
	       	
	       	angleInDegrees = Math.atan2(y_delta, x_delta) * 180 / Math.PI;	   
	       	angle_hovered=Math.round(angleInDegrees)-90;  //subtract 90 to start at top of circle	
	       	if(angle_hovered<0){
	       		angle_hovered=360-Math.abs(angle_hovered);
	       	}
//first slice (orange)
	        percentage_one=30/180;
	        angle_one=(percentage_one)*360;
	        	
//second slice (tan)
	        percentage_two=50/180;
	        angle_two=(percentage_two)*360;
	        angle_two+=angle_one;

//third slice (blue)
        	percentage_three=100/180;
        	angle_three=(percentage_three)*360;
        	angle_three+=angle_two;
        	if(angle_hovered<=angle_one){
        	    $("#one").fadeIn(chunk_fade_speed);	
        	    $('#two, #three').fadeOut(chunk_fade_speed);
        	}
        	else if(angle_hovered<=angle_two){
        	    $("#two").fadeIn(chunk_fade_speed);	
        	    $('#one, #three').fadeOut(chunk_fade_speed);

            }	
        	else if(angle_hovered<=angle_three){
        	    $("#three").fadeIn(chunk_fade_speed);	
        	    $('#two, #one').fadeOut(chunk_fade_speed);
            }	
		        
        }
        function chart_data(e){
        	$('#one,#two,#three').fadeIn(chunk_fade_speed);
       	    if(chart_see(e)){
       	    	$('.chart_holder').mousemove(function(){
       	    		 chart_see(e);
       	    	});
       	    }
        }
        function chart_hover(e){
	    	$('.chart_holder').hover(
	    	function(e){
	    			$(this).mousemove(function(e){
	    				chart_see(e);
	    			});
	    	    
	    	},
	        function(){	        	
        	    $('#one, #two, #three').fadeIn(chunk_fade_speed);
	        });
	    }
	    var total_value=0;
	    for(i=0;i<data_three.length;i++){
        	total_value+=data_three[i].value;
        }	
       	$('button#log_quit_button').click(function(){
       		$('#log_box').fadeOut(chunk_fade_speed);
       	    $('.chart_holder').animate({marginLeft:'20%'},chunk_move_speed,function(){
       			$('.chart,#empty').fadeIn(chunk_fade_speed,function(){
       				chart_hover();
       				chart_click();
       			});
       		});	
       	});  
	    function chart_click(){
		    $('.chart').click(function(){
        		data_index=$(this).index('.chart');
		   		$('.chart, .chart_holder').unbind();
//percentage        		
        		log_percentage=data_three[data_index].value/total_value*100;
        		var text_percent = ('innerText' in log_percentage_span)? 'innerText' : 'textContent';
        		log_percentage_span[text_percent] = Math.round(log_percentage)+'%';
//fraction        		
        		log_fraction=data_three[data_index].value+' out of '+total_value+' answered ';
        		var text_fraction = ('innerText' in log_fraction_span)? 'innerText' : 'textContent';
        		log_fraction_span[text_fraction] = log_fraction;
//label        		
        		log_label=data_three[data_index].label;
        		var text_label = ('innerText' in log_label_span)? 'innerText' : 'textContent';
        		log_label_span[text_label] = log_label;

	        	$('.chart,#empty').not(this).fadeOut(chunk_fade_speed);
		    	$('.chart_holder').animate({marginLeft:'0%'},chunk_move_speed,function(){
		    		$('#log_box').fadeIn(chunk_fade_speed);
		    	});
	       	}); 
       	}
	    $(document).ready(function(){
	    	chart_hover();
	    	chart_click();
	    });