<script type = 'text/javascript'>

//VARS

var section_num = 0;
var option_num = 0;
draw_count=0;
var section_name,section_position,section_width;
var canvas_name;
var canvas;
var canvas_width,canvas_height;
var utensil;

//Curve Control
var a = 0.2;
var	b1 = -10.9;
var b2 = -13.9;
var b3 = -15.9;
var c1 = 15.6;
var c2 = 0;
var x;
var quadratic_y;

var draw_limit = 30;
var draw_speed = 10; //Less is more
var inc=.3;

var x1=1;
var x2=5;


//ARRAYS

var section = new Array();
var mathematics = new Array();
var art = new Array();
var construction = new Array();
construction['count'] = 0;


//BUTTONS

$button_tattoo = $('#button_tattoo');
$button_paint = $('#button_paint');

//Quadratic form: y = ax^2 + bx + c

function quadratic(a,b,c,x){
	quadratic_y = Math.pow(x,2);
	quadratic_y *= a;
	quadratic_y += b*x 
	quadratic_y += c;
	return quadratic_y;
}


mathematics['x'] = 0;
mathematics['y'] = 0;

//Mathematician gives the ARTIST perameters for how make his lines ant tells the ARCHITECT how to place them.

function mathematician(section,section_num,element_ID,draw_count,b){
/*	/////////////////////
		A section is the 'chunk' or 'rank' within the hierarchy of options. 
		Several options can and, most likely, will be presented within a single section. 
		Housing options within the same section represents their equal 'status'. 
		Providing the section's chronological position allows me to determine the section's importance. 
		By differentiating the sections. We can customize them separately. 

		Presumably, as the section number increases, 
		the number of options (presented in the section) will also increase. 
		To present all options, within all sections (of the same 'order'), 
		I must tell the ARCHITECT how to accomidate options spatially 
		(i.e. he shouldn't make all options the same size and squeeze them together). 
		I can also tell the ARTIST to make more asthetic changes to differentiate between 'sections' and 
		'sub-sections'. 
	/////////////////////
*/ 
 	y1=quadratic(a,b,c1,x1);
 	y2=x2;
 	if(draw_count==1){
		section_name = 'paint';	//Section 1
	}
	else{
		section_name = 'tattoo';	//Section 1
	}	
//--Coordinates	
	
	canvas_name = 'canvas_'+section_name;	//Canvas ID
	canvas = document.getElementById(canvas_name);
	canvas_width = canvas.width;
	canvas_height = canvas.height;
	if(draw_count==1){
		x = x2+construction['count'];
		quadratic_y = quadratic(a,b,c2,x);
	}
	else{
		x = x1+construction['count'];
		quadratic_y = quadratic(a,b,c1,x);
	}	
	y = quadratic_y;	
	
	mathematics['canvas_name'] = canvas_name;
	mathematics['center_x'] = canvas_width/2;	//first coordinate x
	mathematics['center_y'] = canvas_height/2;	//first coordinate y
	mathematics['x'] = x;
	mathematics['y'] = y;
			
	return mathematics;
}

//Artist 'conceptualizes' the lines to connect an option to its sub-option(s). He then gives the line to the ARCHITECT.

function artist(section){
	art['stroke_color'] = 'rgba(255,255,255,0.3)';
	art['line_width'] = .5;
	return art;
}

//Architect draws the lines

function architect(section,element_ID,draw_count){
	count = construction['count'];
	if(count<draw_limit){
		canvas_name = section['mathematics']['canvas_name'];
		if(construction['count']){
			last_x = construction['last_x'];
			last_y = construction['last_y'];
		}
		else{
			if(draw_count==1){
				last_x=x2;
				last_y=y2;
			}
			else{
				last_x=x1;
				last_y=y1;
			}	
			
		}	
		x = section['mathematics']['x'];
		y = Math.abs(section['mathematics']['y']);
		stroke_color = section['art']['stroke_color'];
		line_width = section['art']['line_width'];
		
		canvas = document.getElementById(canvas_name);
		ctx = canvas.getContext('2d');
	    ctx.strokeStyle = stroke_color;
	    ctx.lineWidth = line_width;
    	ctx.save();
	    ctx.beginPath();
	    ctx.moveTo(last_x,last_y);
		ctx.quadraticCurveTo(x,y,x,y);
	    ctx.stroke();
	    ctx.closePath();
	    ctx.clip();
	    ctx.restore();
		construction['count']+=inc;
	    construction['fini']=0;
	}
	else{
    		$('#button_image_one').animate({right:'51%'},100);
    		construction['fini']=1;
    }
	construction['last_x']=x;
	construction['last_y']=y;
	return construction;
}
function draw(section,section_num,element_ID,b,draw_count){
    setInterval(function(){
    	section['mathematics'] = mathematician(section,section_num,element_ID,draw_count,b);
    	section['art'] = artist(section,element_ID);
    	section['construction'] = architect(section,element_ID,b);
    	
    }, draw_speed);	
}

$button_tattoo.click(
function(){
	$button_tattoo.addClass('focus');
    temp=draw(section,0,'button_tattoo',b1,0);  
    construction['count']=0;
    construction['last_x']=0;
    construction['last_y']=0;
    clearTimeout(temp); 
});    
	$button_paint.click(
function(){
	$button_paint.addClass('focus');
    temp=draw(section,0,'button_paint',b2,1);  
    construction['count']=0;
    construction['last_x']=0;
    construction['last_y']=0;
    clearTimeout(temp); 
    temp=draw(section,0,'button_paint',b2,1);  

});
	   	canvas = document.getElementById('canvas_tattoo');
	   	ctx = canvas.getContext('2d');
	   	
	   	//one
	    ctx.strokeStyle = 'rgba(0,0,0,0.5)';
	    ctx.lineWidth = 3;
    	ctx.save();
	    ctx.beginPath();
		ctx.moveTo(6,100);
		ctx.quadraticCurveTo(6,150,20,150);
		ctx.stroke();
	    ctx.closePath();
	    ctx.clip();
	    ctx.restore();
	   	
	   	// two
	    ctx.strokeStyle = 'rgba(0,0,0,0.5)';
	    ctx.lineWidth = 3;
    	ctx.save();
	    ctx.beginPath();
	    ctx.moveTo(6,200);
		ctx.quadraticCurveTo(6,245,40,250);
		ctx.stroke();
	    ctx.closePath();
	    ctx.clip();
	    ctx.restore();
	    		
	    ctx.strokeStyle = '#333333';
	    ctx.lineWidth = 5;
    	ctx.save();
	    ctx.beginPath();
	    ctx.moveTo(5,0);
		ctx.quadraticCurveTo(5,350,15,350);
		ctx.stroke();
	    ctx.closePath();
	    ctx.clip();
	    ctx.restore();


	

</script>
